/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : platform_config.h
* Author             : MCD Application Team
* Version            : V2.2.0
* Date               : 06/13/2008
* Description        : Evaluation board specific configuration file.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PLATFORM_CONFIG_H
#define __PLATFORM_CONFIG_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_type.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Uncomment the line corresponding to the STMicroelectronics evaluation board
   used to run the example */
#if !defined (USE_STM3210B_EVAL)
 #define USE_STM3210B_EVAL
#endif


/* Define For ET-STM32F103 Board */
#ifdef USE_STM3210B_EVAL
  #define USB_DISCONNECT                      GPIOD  					
  #define USB_DISCONNECT_PIN                  GPIO_Pin_2                // PD2
  #define RCC_APB2Periph_GPIO_DISCONNECT      RCC_APB2Periph_GPIOD

  #define RCC_APB2Periph_GPIO_KEY             RCC_APB2Periph_GPIOA      // PA
  #define RCC_APB2Periph_GPIO_TAMPER          RCC_APB2Periph_GPIOC      // PC
  #define RCC_APB2Periph_GPIO_IOAIN           RCC_APB2Periph_GPIOA      // PA
  #define RCC_APB2Periph_GPIO_LED             RCC_APB2Periph_GPIOB      // PB

  #define GPIO_KEY                            GPIOA                     // PA
  #define GPIO_TAMPER                         GPIOC                     // PC
  #define GPIO_IOAIN                          GPIOA                     // PA
  #define GPIO_LED                            GPIOB                     // PB

  #define GPIO_KEY_PIN                        GPIO_Pin_0                // PA0
  #define GPIO_TAMPER_PIN                     GPIO_Pin_13               // PC13
  #define GPIO_IOAIN_PIN                      GPIO_Pin_1                // PA1
  
  #define GPIO_LED1_PIN                       GPIO_Pin_8                // PB8
  #define GPIO_LED2_PIN                       GPIO_Pin_9                // PB9 
  #define GPIO_LED3_PIN                       GPIO_Pin_10               // PB10
  #define GPIO_LED4_PIN                       GPIO_Pin_11               // PB11 
  #define GPIO_LED5_PIN                       GPIO_Pin_12               // PB12
  #define GPIO_LED6_PIN                       GPIO_Pin_13               // PB13
  #define GPIO_LED7_PIN                       GPIO_Pin_14               // PB14
  #define GPIO_LED8_PIN                       GPIO_Pin_15               // PB15

  #define GPIO_KEY_PORTSOURCE                 GPIO_PortSourceGPIOA      // PA0
  #define GPIO_KEY_PINSOURCE                  GPIO_PinSource0           
  #define GPIO_KEY_EXTI_Line                  EXTI_Line0                

  #define GPIO_TAMPER_PORTSOURCE              GPIO_PortSourceGPIOC      // PC13
  #define GPIO_TAMPER_PINSOURCE               GPIO_PinSource13
  #define GPIO_TAMPER_EXTI_Line               EXTI_Line13

  #define ADC_AIN_CHANNEL                     ADC_Channel_1             // PA1
#endif /* ET-STM32F103 */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#endif /* __PLATFORM_CONFIG_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/

